<?php
require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/includes/auth.php';

if (!isset($_SESSION['user_id'])) {
    die('Please log in first');
}

if ($_SESSION['role_name'] !== 'DG' && $_SESSION['role_name'] !== 'DGA') {
    die('Only administrators can run migrations');
}

$conn = get_db_connection();
if (!$conn) {
    die('Connection failed: ' . mysqli_connect_error());
}

$migrations_dir = __DIR__ . '/database/migrations';
$migration_files = glob($migrations_dir . '/*.sql');
sort($migration_files);

echo "<h2>Applying Migrations...</h2>";
foreach ($migration_files as $file) {
    echo "<p>Applying: " . basename($file) . "... ";
    $sql = file_get_contents($file);
    if ($conn->multi_query($sql)) {
        while ($conn->more_results()) {
            $conn->next_result();
        }
        echo "✓ Done</p>";
    } else {
        echo "✗ Error: " . $conn->error . "</p>";
    }
}

$conn->close();
echo "<p><a href='/masunzu_bar_hotel/dashboards/admin_dashboard.php'>Back to Dashboard</a></p>";
?>
