<?php
require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/auth.php';
require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/functions.php';
require_login();

// Restrict to Accountant role
if ($_SESSION['role_name'] !== 'Accountant') {
    error_log("Unauthorized access to accountant_balance.php by user {$_SESSION['full_name']} (Role: {$_SESSION['role_name']})");
    header("Location: /masunzu_bar_hotel/dashboards/" . strtolower(str_replace(' ', '_', $_SESSION['role_name'])) . "_dashboard.php");
    exit;
}

// Initialize database connection
$conn = get_db_connection();
if (!$conn) {
    error_log("Database connection failed in accountant_balance.php: " . mysqli_connect_error());
    echo "<p style='color: #FF0000; text-align: center; padding: 20px;'>Échec de la connexion à la base de données. Contactez l'administrateur.</p>";
    include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/footer.php';
    exit;
}

// Fetch accountant balance from accountant_balance table
$stmt = $conn->prepare("SELECT balance FROM accountant_balance WHERE accountant_id = ?");
if (!$stmt) {
    error_log("Failed to prepare accountant balance query: " . $conn->error);
    // Fallback to calculating from cash_transfer
    $stmt = $conn->prepare("SELECT COALESCE(SUM(amount), 0) AS balance FROM cash_transfer WHERE accountant_id = ? AND status = 'received'");
    if ($stmt) {
        $stmt->bind_param("i", $_SESSION['user_id']);
        $stmt->execute();
        $balance = (float)($stmt->get_result()->fetch_assoc()['balance'] ?? 0.00);
        $stmt->close();
    } else {
        $balance = 0.00;
    }
} else {
$stmt->bind_param("i", $_SESSION['user_id']);
$stmt->execute();
    $result = $stmt->get_result();
    $balanceRow = $result->fetch_assoc();
    $balance = (float)($balanceRow['balance'] ?? 0.00);
$stmt->close();
}

// Also fetch expenses paid from this balance
$stmtExpenses = $conn->prepare("SELECT COALESCE(SUM(amount), 0) AS total_expenses FROM expense WHERE accountant_id = ?");
if ($stmtExpenses) {
    $stmtExpenses->bind_param("i", $_SESSION['user_id']);
    $stmtExpenses->execute();
    $totalExpenses = (float)($stmtExpenses->get_result()->fetch_assoc()['total_expenses'] ?? 0.00);
    $stmtExpenses->close();
} else {
    $totalExpenses = 0.00;
}

// Calculate available balance (received - expenses)
$availableBalance = $balance - $totalExpenses;
if ($availableBalance < 0) {
    $availableBalance = 0.00;
}

$conn->close();

include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/header.php';
?>
<div class="container" style="padding: 20px; background: linear-gradient(135deg, #4B2F1F 0%, #F4A261 100%); min-height: 100vh;">
    <div style="max-width: 1200px; margin: 30px auto;">
        <h1 style="color: #4B2F1F; font-size: 28px; font-weight: bold; text-align: center; margin-bottom: 20px;">Solde Comptable</h1>
        <div style="background-color: #FFFFFF; padding: 20px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
            <h2 style="color: #4B2F1F; font-size: 22px; margin-bottom: 15px;">Solde Actuel</h2>
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 20px; margin-bottom: 20px;">
                <div style="text-align: center; padding: 15px; background-color: #F4F0E4; border-radius: 8px;">
                    <div style="font-size: 14px; color: #4B2F1F; margin-bottom: 8px;">Total Reçu</div>
                    <div style="font-size: 24px; font-weight: bold; color: #4B2F1F;"><?php echo number_format($balance, 2, ',', '.'); ?> BIF</div>
                </div>
                <div style="text-align: center; padding: 15px; background-color: #F4F0E4; border-radius: 8px;">
                    <div style="font-size: 14px; color: #4B2F1F; margin-bottom: 8px;">Total Dépenses</div>
                    <div style="font-size: 24px; font-weight: bold; color: #DC3545;"><?php echo number_format($totalExpenses, 2, ',', '.'); ?> BIF</div>
                </div>
                <div style="text-align: center; padding: 15px; background-color: #4B2F1F; border-radius: 8px;">
                    <div style="font-size: 14px; color: #F4F0E4; margin-bottom: 8px;">Solde Disponible</div>
                    <div style="font-size: 28px; font-weight: bold; color: #F4A261;"><?php echo number_format($availableBalance, 2, ',', '.'); ?> BIF</div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/footer.php'; ?>