<?php
require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/auth.php';
require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/functions.php';
require_login();

// Restrict to Accountant role
if ($_SESSION['role_name'] !== 'Accountant') {
    error_log("Unauthorized access to track.php by user {$_SESSION['full_name']} (Role: {$_SESSION['role_name']})");
    header("Location: /masunzu_bar_hotel/dashboards/" . strtolower(str_replace(' ', '_', $_SESSION['role_name'])) . "_dashboard.php");
    exit;
}

// Initialize database connection
$conn = get_db_connection();
if (!$conn) {
    error_log("Database connection failed in track.php: " . mysqli_connect_error());
    echo "<p style='color: #FF0000; text-align: center; padding: 20px;'>Database connection failed. Contact administrator.</p>";
    include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/footer.php';
    exit;
}

// Fetch loan repayments
$stmt = $conn->prepare("
    SELECT lp.id,
           c.full_name AS customer_name,
           lp.payment_amount,
           lp.payment_method,
           lp.payment_date,
           u.full_name AS created_by_name,
           c.loan_balance_bif,
           lp.notes,
           lp.province_id,
           p.name AS province_name,
           lp.invoice_id,
           ui.invoice_number,
           lp.ledger_entry_id,
           cll.reference_table,
           cll.reference_id
    FROM loan_payment lp
    LEFT JOIN customer c ON lp.customer_id = c.id
    LEFT JOIN user u ON lp.created_by = u.id
    LEFT JOIN province p ON lp.province_id = p.id
    LEFT JOIN unpaid_invoices ui ON lp.invoice_id = ui.id
    LEFT JOIN customer_loan_ledger cll ON lp.ledger_entry_id = cll.id
    ORDER BY lp.payment_date DESC
");
$stmt->execute();
$loan_payments = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();

$conn->close();

include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/header.php';
?>
<div class="container" style="padding: 20px; background: linear-gradient(135deg, #4B2F1F 0%, #F4A261 100%); min-height: 100vh;">
    <div style="max-width: 1200px; margin: 30px auto;">
        <h1 style="color: #4B2F1F; font-size: 28px; font-weight: bold; text-align: center; margin-bottom: 20px;">Track Loan Repayments</h1>
        <div style="background-color: #FFFFFF; padding: 20px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
            <h2 style="color: #4B2F1F; font-size: 22px; margin-bottom: 15px;">Loan Payments</h2>
            <?php if (empty($loan_payments)): ?>
                <p style="color: #4B2F1F; text-align: center;">No loan payments found.</p>
            <?php else: ?>
                <table style="width: 100%; border-collapse: collapse;">
                    <thead>
                        <tr style="background-color: #4B2F1F; color: #F4F0E4;">
                            <th style="padding: 10px; text-align: left;">ID</th>
                            <th style="padding: 10px; text-align: left;">Customer</th>
                            <th style="padding: 10px; text-align: left;">Payment Amount (BIF)</th>
                            <th style="padding: 10px; text-align: left;">Payment Method</th>
                            <th style="padding: 10px; text-align: left;">Payment Date</th>
                            <th style="padding: 10px; text-align: left;">Created By</th>
                            <th style="padding: 10px; text-align: left;">Province</th>
                            <th style="padding: 10px; text-align: left;">Invoice Ref</th>
                            <th style="padding: 10px; text-align: left;">Ledger Ref</th>
                            <th style="padding: 10px; text-align: left;">Current Loan Balance</th>
                            <th style="padding: 10px; text-align: left;">Notes</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($loan_payments as $payment): ?>
                            <tr style="border-bottom: 1px solid #F4F0E4;">
                                <td style="padding: 10px;"><?php echo htmlspecialchars($payment['id']); ?></td>
                                <td style="padding: 10px;"><?php echo htmlspecialchars($payment['customer_name']); ?></td>
                                <td style="padding: 10px;"><?php echo number_format((int)($payment['payment_amount'] ?? 0), 0, ',', '.'); ?></td>
                                <td style="padding: 10px;"><?php echo htmlspecialchars($payment['payment_method']); ?></td>
                                <td style="padding: 10px;"><?php echo date('Y-m-d H:i', strtotime($payment['payment_date'])); ?></td>
                                <td style="padding: 10px;"><?php echo htmlspecialchars($payment['created_by_name']); ?></td>
                                <td style="padding: 10px;"><?php echo htmlspecialchars($payment['province_name'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></td>
                                <td style="padding: 10px;">
                                    <?php
                                        if (!empty($payment['invoice_number'])) {
                                            echo htmlspecialchars($payment['invoice_number'], ENT_QUOTES, 'UTF-8');
                                        } elseif (!empty($payment['invoice_id'])) {
                                            echo 'Invoice #' . (int)$payment['invoice_id'];
                                        } else {
                                            echo 'General repayment';
                                        }
                                    ?>
                                </td>
                                <td style="padding: 10px;">
                                    <?php
                                        if (!empty($payment['ledger_entry_id'])) {
                                            $reference = [];
                                            $reference[] = 'LED-' . (int)$payment['ledger_entry_id'];
                                            if (!empty($payment['reference_table'])) {
                                                $reference[] = htmlspecialchars($payment['reference_table'], ENT_QUOTES, 'UTF-8');
                                            }
                                            if (!empty($payment['reference_id'])) {
                                                $reference[] = '#' . (int)$payment['reference_id'];
                                            }
                                            echo implode(' • ', $reference);
                                        } else {
                                            echo '-';
                                        }
                                    ?>
                                </td>
                                <td style="padding: 10px;"><?php echo number_format((int)($payment['loan_balance_bif'] ?? 0), 0, ',', '.'); ?></td>
                                <td style="padding: 10px;"><?php echo htmlspecialchars($payment['notes'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/footer.php'; ?>
