<?php
require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/auth.php';
require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/functions.php';
require_login();

// Restrict to Operation Manager, DG, DGA, Board, Admin roles
$allowed_roles = ['Operation Manager', 'DG', 'DGA', 'Board', 'Admin'];
if (!in_array($_SESSION['role_name'], $allowed_roles)) {
    error_log("Unauthorized access to add_main_stock_details.php by user {$_SESSION['full_name']} (Role: {$_SESSION['role_name']})");
    $dashboard_map = [
        'Board' => 'admin_dashboard.php',
        'DG' => 'admin_dashboard.php',
        'DGA' => 'admin_dashboard.php',
        'Admin' => 'admin_dashboard.php',
        'Operation Manager' => 'operation_dashboard.php',
        'Stock Manager' => 'stock_manager_dashboard.php',
        'Accountant' => 'accountant_dashboard.php',
        'Caissier_Comptable' => 'cashier_dashboard.php',
    ];
    $dashboard = $dashboard_map[$_SESSION['role_name']] ?? 'admin_dashboard.php';
    header("Location: /masunzu_bar_hotel/dashboards/" . $dashboard);
    exit;
}

// Check for transfer_id or log_id
$transfer_id = $_GET['transfer_id'] ?? '';
$log_id = $_GET['log_id'] ?? '';
$source_type = $_GET['source_type'] ?? 'transfer'; // 'transfer' or 'direct_add'

if (!$transfer_id && !$log_id) {
    header("Location: add_main_stock_history.php");
    exit;
}

// Initialize database connection
$conn = get_db_connection();
if (!$conn) {
    error_log("Database connection failed in add_main_stock_details.php: " . mysqli_connect_error());
    echo "<p style='color: #FF0000; text-align: center; padding: 20px;'>Échec de la connexion à la base de données. Contactez l'administrateur.</p>";
    include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/footer.php';
    exit;
}

$details = null;
$is_transfer = false;

if ($transfer_id && $source_type === 'transfer') {
    // Fetch transfer details with province and reception info
    $query = "SELECT st.id, 
                     st.product_id, 
                     st.quantity, 
                     st.unit_type, 
                     st.sent_at as created_at,
                     st.received_at,
                     st.shipment_id,
                     st.province_id,
                     st.operation_manager_id as user_id, 
                     u.full_name AS user_name, 
                     p.name AS product_name, 
                     p.crate_quantity, 
                     pr.name as province_name,
                     st.driver_name,
                     st.driver_mobile,
                     st.plate_number,
                     st.estimated_arrival,
                     'transfer' as source_type
              FROM stock_transfer st
              LEFT JOIN user u ON st.operation_manager_id = u.id
              LEFT JOIN product p ON st.product_id = p.id
              LEFT JOIN province pr ON st.province_id = pr.id
              WHERE st.id = ? AND st.status = 'confirmed'";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $transfer_id);
    $stmt->execute();
    $details = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    $is_transfer = true;
} elseif ($log_id && $source_type === 'direct_add') {
    // Fetch log entry details for direct addition
    $query = "SELECT l.id, 
                     p.id as product_id,
                     0 as quantity,  -- Will be extracted from description
                     'crates' as unit_type,
                     l.created_at,
                     l.user_id,
                     u.full_name AS user_name,
                     p.name AS product_name,
                     COALESCE(p.crate_quantity, 12) as crate_quantity,
                     l.description,
                     'direct_add' as source_type
              FROM log l
              LEFT JOIN user u ON l.user_id = u.id
              LEFT JOIN product p ON l.description LIKE CONCAT('%', p.name, '%')
              WHERE l.id = ? AND l.action = 'add_stock' AND l.description LIKE '%to main stock%'";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $log_id);
    $stmt->execute();
    $details = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    
    // Extract quantity from description
    if ($details && isset($details['description'])) {
        $desc = $details['description'];
        if (preg_match('/Added\s+([\d,\.]+)\s+(?:crates?|bottles?)/i', $desc, $matches)) {
            $details['quantity'] = (int)str_replace([',', '.'], '', $matches[1]);
        } elseif (preg_match('/\(([\d,\.]+)\s*(?:crates?|bottles?)\)/i', $desc, $matches)) {
            $details['quantity'] = (int)str_replace([',', '.'], '', $matches[1]);
        }
    }
    $is_transfer = false;
}

if (!$details) {
    error_log("No details found in add_main_stock_details.php for transfer_id: $transfer_id, log_id: $log_id");
    header("Location: add_main_stock_history.php");
    exit;
}

$conn->close();
include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/header.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>
<body>
    <div class="container" style="padding: 20px; background: linear-gradient(135deg, #4B2F1F 0%, #F4A261 100%); min-height: 100vh; box-sizing: border-box;">
        <div style="width: 100%; max-width: 100%; margin: 30px auto; padding: 0 20px;">
            <h1 style="color: #4B2F1F; font-size: 28px; font-weight: bold; text-align: center; margin-bottom: 20px;">
                Détails de l'Ajout au Stock Principal
                <?php if ($is_transfer): ?>
                    - Transfert ID: <?php echo htmlspecialchars($details['id']); ?>
                <?php else: ?>
                    - Ajout Direct ID: <?php echo htmlspecialchars($details['id']); ?>
                <?php endif; ?>
            </h1>
            <div style="background-color: #FFFFFF; padding: 20px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                <table style="width: 100%; border-collapse: collapse;">
                    <tr style="border-bottom: 1px solid #E0E0E0;">
                        <th style="padding: 10px; text-align: left; color: #4B2F1F; width: 30%; border: none;">Champ</th>
                        <th style="padding: 10px; text-align: left; color: #4B2F1F; border: none;">Valeur</th>
                    </tr>
                    <tr>
                        <td style="padding: 10px; font-weight: 600;">Type</td>
                        <td style="padding: 10px;">
                            <?php if ($is_transfer): ?>
                                <span style="color: #FF9800; font-weight: 600;">📦 Transfert vers Dépôt</span>
                                <?php if (isset($details['province_name']) && $details['province_name']): ?>
                                    <small style="color: #666; display: block; margin-top: 5px;">Stock transféré du stock principal vers le dépôt <strong style="color: #FF9800;"><?php echo htmlspecialchars($details['province_name']); ?></strong></small>
                                <?php else: ?>
                                    <small style="color: #666; display: block; margin-top: 5px;">Stock transféré du stock principal vers un dépôt</small>
                                <?php endif; ?>
                            <?php else: ?>
                                <span style="color: #4CAF50; font-weight: 600;">➕ Ajout Direct</span>
                                <small style="color: #666; display: block; margin-top: 5px;">Stock ajouté directement au stock principal (non réparti)</small>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 10px; font-weight: 600;">ID</td>
                        <td style="padding: 10px;"><?php echo htmlspecialchars($details['id']); ?></td>
                    </tr>
                    <tr>
                        <td style="padding: 10px; font-weight: 600;">Ajouté Par</td>
                        <td style="padding: 10px;"><?php echo htmlspecialchars($details['user_name'] ?: 'Inconnu'); ?></td>
                    </tr>
                    <tr>
                        <td style="padding: 10px; font-weight: 600;">Produit</td>
                        <td style="padding: 10px;"><?php echo htmlspecialchars($details['product_name'] ?: 'N/A'); ?></td>
                    </tr>
                    <tr>
                        <td style="padding: 10px; font-weight: 600;">Quantité</td>
                        <td style="padding: 10px;">
                            <?php 
                            $qty = (int)($details['quantity'] ?? 0);
                            $unit_type = $details['unit_type'] ?? 'crates';
                            $crate_qty = (int)($details['crate_quantity'] ?? 12);
                            if ($qty > 0) {
                                echo format_quantity($qty, $unit_type, $crate_qty);
                            } else {
                                echo 'N/A';
                            }
                            ?>
                        </td>
                    </tr>
                    <?php if ($is_transfer): ?>
                    <tr>
                        <td style="padding: 10px; font-weight: 600;">Dépôt de Destination</td>
                        <td style="padding: 10px;">
                            <span style="color: #FF9800; font-weight: 600;">📍 <?php echo htmlspecialchars($details['province_name'] ?: 'N/A'); ?></span>
                        </td>
                    </tr>
                    <?php if (isset($details['shipment_id']) && $details['shipment_id']): ?>
                    <tr>
                        <td style="padding: 10px; font-weight: 600;">ID d'Expédition</td>
                        <td style="padding: 10px;"><strong><?php echo htmlspecialchars($details['shipment_id']); ?></strong></td>
                    </tr>
                    <?php endif; ?>
                    <tr>
                        <td style="padding: 10px; font-weight: 600;">Date et Heure d'Envoi</td>
                        <td style="padding: 10px;">
                            <?php if ($details['created_at']): ?>
                                <span style="color: #2196F3;">📤 <?php echo date('d/m/Y à H:i:s', strtotime($details['created_at'])); ?></span>
                            <?php else: ?>
                                N/A
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 10px; font-weight: 600;">Date et Heure de Réception</td>
                        <td style="padding: 10px;">
                            <?php if (isset($details['received_at']) && $details['received_at']): ?>
                                <span style="color: #4CAF50;">✅ <?php echo date('d/m/Y à H:i:s', strtotime($details['received_at'])); ?></span>
                            <?php else: ?>
                                <span style="color: #FF9800;">⏳ En attente de réception</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php if (isset($details['estimated_arrival']) && $details['estimated_arrival']): ?>
                    <tr>
                        <td style="padding: 10px; font-weight: 600;">Date d'Arrivée Estimée</td>
                        <td style="padding: 10px;"><?php echo date('d/m/Y à H:i', strtotime($details['estimated_arrival'])); ?></td>
                    </tr>
                    <?php endif; ?>
                    <?php if (isset($details['driver_name']) && $details['driver_name']): ?>
                    <tr>
                        <td style="padding: 10px; font-weight: 600;">Informations du Conducteur</td>
                        <td style="padding: 10px;">
                            Nom: <?php echo htmlspecialchars($details['driver_name']); ?><br>
                            <?php if (isset($details['driver_mobile']) && $details['driver_mobile']): ?>
                                Téléphone: <?php echo htmlspecialchars($details['driver_mobile']); ?><br>
                            <?php endif; ?>
                            <?php if (isset($details['plate_number']) && $details['plate_number']): ?>
                                Plaque: <?php echo htmlspecialchars($details['plate_number']); ?>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endif; ?>
                    <?php else: ?>
                    <tr>
                        <td style="padding: 10px; font-weight: 600;">Date d'Ajout</td>
                        <td style="padding: 10px;"><?php echo $details['created_at'] ? date('d/m/Y à H:i:s', strtotime($details['created_at'])) : 'N/A'; ?></td>
                    </tr>
                    <?php if (isset($details['description'])): ?>
                    <tr>
                        <td style="padding: 10px; font-weight: 600;">Description Complète</td>
                        <td style="padding: 10px; color: #666; font-style: italic;"><?php echo htmlspecialchars($details['description']); ?></td>
                    </tr>
                    <?php endif; ?>
                    <?php endif; ?>
                </table>
                <a href="add_main_stock_history.php" style="display: inline-block; margin-top: 20px; background-color: #4B2F1F; color: #F4F0E4; padding: 10px 20px; border-radius: 8px; text-decoration: none; font-size: 14px;">← Retour à l'Historique</a>
            </div>
        </div>
        <style>
            table tr:hover {
                background-color: #F4A26120;
            }
            table {
                border-collapse: collapse;
            }
            table th, table td {
                border: none;
            }
            a:hover {
                background-color: #F4A261;
                color: #4B2F1F;
                transform: translateY(-2px);
                box-shadow: 0 4px 8px rgba(0,0,0,0.3);
            }
            @media (max-width: 768px) {
                .container {
                    padding: 10px;
                }
                .container > div {
                    max-width: 90%;
                }
                h1 {
                    font-size: 20px;
                }
                table th, table td {
                    font-size: 13px;
                }
            }
            @media (max-width: 480px) {
                .container {
                    padding: 5px;
                }
                .container > div {
                    max-width: 95%;
                }
                h1 {
                    font-size: 18px;
                }
                table th, table td, a {
                    font-size: 12px;
                }
            }
        </style>
    </div>
</body>
<?php include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/footer.php'; ?>