<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../includes/functions.php';

try {
    require_login();
    $marketingRoleNames = ['Chef Marketing', 'Agent Marketing', 'Marketing Agent', 'Marketing Head'];
    $allowed_roles = [1, 2, 3, 4, 5, 6, 7, 8, 9];
    $role_id = $_SESSION['role_id'];
    $role_name = $_SESSION['role_name'] ?? '';
    if (!in_array($role_id, $allowed_roles, true) && !in_array($role_name, $marketingRoleNames, true) && $role_name !== 'Board') {
        header('Location: /masunzu_bar_hotel/dashboards/unauthorized.php');
        exit;
    }
    $roleName = $_SESSION['role_name'] ?? '';
    $marketingRoleNames = ['Chef Marketing', 'Agent Marketing', 'Marketing Agent'];
    $conn = get_db_connection();
    if (!$conn) {
        throw new Exception('Échec de la connexion à la base de données: ' . mysqli_connect_error());
    }
    $column_check = $conn->query("SHOW COLUMNS FROM expense LIKE 'payment_method'");
    if (!$column_check) {
        throw new Exception('Failed to inspect expense table: ' . $conn->error);
    }
    if ($column_check->num_rows === 0) {
        if (!$conn->query("ALTER TABLE expense ADD COLUMN payment_method ENUM('cash','bank_transfer','mobile') DEFAULT 'cash'")) {
            throw new Exception('Failed to add payment_method column: ' . $conn->error);
        }
    }
    if ($column_check instanceof mysqli_result) {
        $column_check->free();
    }
    if (!isset($_SESSION['province_id'])) {
        $stmt = $conn->prepare('SELECT province_id FROM user WHERE id = ?');
        $stmt->bind_param('i', $_SESSION['user_id']);
        $stmt->execute();
        $province_row = $stmt->get_result()->fetch_assoc();
        $stmt->close();
        $_SESSION['province_id'] = $province_row['province_id'] ?? null;
    }
    $province_id = $_SESSION['province_id'];
    $global_roles = [1, 2, 3, 4, 5, 6, 7];
    $from_date = filter_input(INPUT_GET, 'from_date', FILTER_UNSAFE_RAW) ?? '';
    $to_date = filter_input(INPUT_GET, 'to_date', FILTER_UNSAFE_RAW) ?? '';
    $search = filter_input(INPUT_GET, 'search', FILTER_UNSAFE_RAW) ?? '';
    $filter_province = filter_input(INPUT_GET, 'province', FILTER_VALIDATE_INT) ?? '';
    $query = 'SELECT r.id, r.total_amount, r.created_at AS requested_at, r.comments, r.province_id, r.recipient_type, r.recipient_external_name, r.recipient_external_phone, p.name AS province_name, u.full_name AS initiator_name, recipient.full_name AS recipient_name, e.amount AS paid_amount, e.receipt_number, e.payment_method, e.created_at AS paid_at, cashier.full_name AS cashier_name, accountant_user.full_name AS accountant_name FROM requisition r JOIN expense e ON e.requisition_id = r.id LEFT JOIN province p ON r.province_id = p.id LEFT JOIN user u ON r.user_id = u.id LEFT JOIN user recipient ON r.recipient_id = recipient.id LEFT JOIN user cashier ON e.cashier_id = cashier.id LEFT JOIN user accountant_user ON e.accountant_id = accountant_user.id WHERE r.status = \'paid\' AND e.payment_status = \'processed\'';
    $params = [];
    $types = '';
    if (in_array($role_id, $global_roles, true)) {
        if ($filter_province) {
            $query .= ' AND r.province_id = ?';
            $params[] = $filter_province;
            $types .= 'i';
        }
    } else {
        if ($province_id) {
            $query .= ' AND r.province_id = ?';
            $params[] = $province_id;
            $types .= 'i';
        } else {
            $query .= ' AND r.province_id IS NULL';
        }
    }
    if (in_array($roleName, $marketingRoleNames, true)) {
        $query .= ' AND r.user_id = ?';
        $params[] = (int)($_SESSION['user_id'] ?? 0);
        $types .= 'i';
    }
    if ($from_date) {
        $query .= ' AND e.created_at >= ?';
        $params[] = $from_date . ' 00:00:00';
        $types .= 's';
    }
    if ($to_date) {
        $query .= ' AND e.created_at <= ?';
        $params[] = $to_date . ' 23:59:59';
        $types .= 's';
    }
    if ($search) {
        $query .= ' AND (e.receipt_number LIKE ? OR u.full_name LIKE ? OR recipient.full_name LIKE ? OR cashier.full_name LIKE ?)';
        $search_like = '%' . $search . '%';
        $params[] = $search_like;
        $params[] = $search_like;
        $params[] = $search_like;
        $params[] = $search_like;
        $types .= 'ssss';
    }
    $query .= ' ORDER BY e.created_at DESC';
    $stmt = $conn->prepare($query);
    if ($types) {
        $stmt->bind_param($types, ...$params);
    }
    $stmt->execute();
    $result = $stmt->get_result();
    $paid_requisitions = $result->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
    $total_paid = 0;
    foreach ($paid_requisitions as $row) {
        $total_paid += (float)($row['paid_amount'] ?? 0);
    }
    $provinces = [];
    if (in_array($role_id, $global_roles, true)) {
        $province_stmt = $conn->prepare('SELECT id, name FROM province ORDER BY name');
        $province_stmt->execute();
        $provinces = $province_stmt->get_result()->fetch_all(MYSQLI_ASSOC);
        $province_stmt->close();
    }
    $conn->close();
} catch (Exception $e) {
    error_log('ERROR in accountant/paid_requisitions_history.php: ' . $e->getMessage());
    echo "<p style='color: #FF0000; text-align: center; padding: 20px;'>Error: " . htmlspecialchars($e->getMessage()) . "</p>";
    include __DIR__ . '/../../includes/footer.php';
    exit;
}

include __DIR__ . '/../../includes/header.php';
?>
<style>
    .paid-history-page { padding: 30px 34px 70px; background: #f5f7fb; min-height: calc(100vh - 70px); }
    .history-card { width: 100%; background: #ffffff; border-radius: 18px; padding: 26px 32px; box-shadow: 0 16px 40px rgba(15,23,42,0.12); display: flex; flex-direction: column; gap: 20px; }
    .history-header { display: flex; flex-wrap: wrap; justify-content: space-between; gap: 18px; }
    .history-header h2 { margin: 0; font-size: 28px; color: #1f2937; }
    .history-header p { margin: 6px 0 0; color: #64748b; font-size: 15px; }
    .history-total { text-align: right; }
    .history-total span { display: block; color: #64748b; font-size: 13px; text-transform: uppercase; letter-spacing: 0.08em; }
    .history-total strong { font-size: 30px; color: #111827; }
    .filters-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(220px, 1fr)); gap: 16px; border: 1px solid #e2e8f0; border-radius: 12px; padding: 18px; background: #f9fafc; }
    .filter-group { display: flex; flex-direction: column; gap: 8px; }
    .filter-group label { font-size: 12px; text-transform: uppercase; letter-spacing: 0.08em; color: #475569; font-weight: 600; }
    .filter-group input, .filter-group select { padding: 10px 12px; border-radius: 8px; border: 1px solid #cbd5f5; font-size: 14px; background: #fff; }
    .filters-actions { display: flex; flex-wrap: wrap; gap: 12px; align-items: flex-end; }
    .btn { padding: 10px 20px; border-radius: 8px; border: none; font-weight: 600; cursor: pointer; }
    .btn-primary { background: linear-gradient(135deg, #2563eb, #7c3aed); color: #fff; }
    .btn-secondary { background: #e2e8f0; color: #1f2937; text-decoration: none; display: inline-flex; align-items: center; justify-content: center; }
    .history-kpis { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 14px; }
    .kpi-tile { border: 1px solid #e2e8f0; border-radius: 12px; padding: 16px; background: #f8fafc; display: flex; flex-direction: column; gap: 6px; }
    .kpi-tile span { font-size: 12px; letter-spacing: 0.08em; text-transform: uppercase; color: #475569; }
    .kpi-tile strong { font-size: 22px; color: #0f172a; }
    .table-wrapper { overflow-x: auto; border: 1px solid #e2e8f0; border-radius: 12px; }
    table.requisition-table { width: 100%; border-collapse: collapse; min-width: 900px; }
    table.requisition-table thead { background: #111827; color: #f8fafc; }
    table.requisition-table th, table.requisition-table td { padding: 12px 14px; text-align: left; font-size: 14px; border-bottom: 1px solid #e2e8f0; }
    table.requisition-table tbody tr:nth-child(odd) { background: #fdfdfd; }
    .cell-strong { font-weight: 600; color: #1f2937; }
    .cell-muted { color: #64748b; font-size: 12px; }
    .empty { padding: 30px; text-align: center; color: #475569; }
@media (max-width: 768px) {
    .paid-history-page { padding: 22px 18px 50px; }
    .history-card { padding: 22px; }
}
</style>
<div class="paid-history-page">
    <div class="history-card">
        <div class="history-header">
            <div>
                <h2>Historique des Réquisitions Payées</h2>
                <p>Vue complète des paiements <?php echo in_array($role_id, $global_roles, true) ? 'toutes provinces confondues.' : 'pour votre province.'; ?></p>
            </div>
            <div class="history-total">
                <span>Total payé</span>
                <strong><?php echo number_format($total_paid, 0, '.', ','); ?> BIF</strong>
            </div>
        </div>
        <form method="GET" class="filters-grid">
            <div class="filter-group">
                <label for="search">Rechercher</label>
                <input type="text" id="search" name="search" value="<?php echo htmlspecialchars($search, ENT_QUOTES, 'UTF-8'); ?>" placeholder="ID, initiateur, destinataire...">
            </div>
            <div class="filter-group">
                <label for="from_date">Date début</label>
                <input type="date" id="from_date" name="from_date" value="<?php echo htmlspecialchars($from_date, ENT_QUOTES, 'UTF-8'); ?>">
            </div>
            <div class="filter-group">
                <label for="to_date">Date fin</label>
                <input type="date" id="to_date" name="to_date" value="<?php echo htmlspecialchars($to_date, ENT_QUOTES, 'UTF-8'); ?>">
            </div>
            <?php if (in_array($role_id, $global_roles, true)): ?>
                <div class="filter-group">
                    <label for="province">Province</label>
                    <select id="province" name="province">
                        <option value="">Toutes les provinces</option>
                        <?php foreach ($provinces as $province): ?>
                            <option value="<?php echo htmlspecialchars($province['id'], ENT_QUOTES, 'UTF-8'); ?>" <?php echo (string)$filter_province === (string)$province['id'] ? 'selected' : ''; ?>><?php echo htmlspecialchars($province['name'], ENT_QUOTES, 'UTF-8'); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            <?php endif; ?>
            <div class="filters-actions">
                <button type="submit" class="btn btn-primary">Appliquer Filtres</button>
                <a class="btn btn-secondary" href="<?php echo htmlspecialchars($_SERVER['PHP_SELF'], ENT_QUOTES, 'UTF-8'); ?>">Réinitialiser</a>
            </div>
        </form>
        <div class="history-kpis">
            <div class="kpi-tile">
                <span>Enregistrements</span>
                <strong><?php echo count($paid_requisitions); ?></strong>
            </div>
            <div class="kpi-tile">
                <span>Montant moyen</span>
                <strong><?php echo count($paid_requisitions) ? number_format($total_paid / count($paid_requisitions), 0, '.', ',') : '0'; ?> BIF</strong>
            </div>
            <div class="kpi-tile">
                <span>Dernier paiement</span>
                <strong><?php echo !empty($paid_requisitions) ? htmlspecialchars(date('Y-m-d', strtotime($paid_requisitions[0]['paid_at'] ?? 'now')), ENT_QUOTES, 'UTF-8') : '—'; ?></strong>
            </div>
        </div>
        <?php if (empty($paid_requisitions)): ?>
            <div class="empty">Aucune réquisition payée trouvée correspondant à vos critères.</div>
        <?php else: ?>
            <div class="table-wrapper">
                <table class="requisition-table">
                    <thead>
                        <tr>
                            <th>ID / Date</th>
                            <th>Province</th>
                            <th>Initiateur</th>
                            <th>Destinataire</th>
                            <th>Caissier</th>
                            <th>Comptable</th>
                            <th>Reçu</th>
                            <th>Méthode</th>
                            <th>Montant</th>
                            <th>Date paiement</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($paid_requisitions as $row): ?>
                            <?php
                                $recipientDisplay = trim($row['recipient_name'] ?? '');
                                if ($recipientDisplay === '' || strcasecmp($recipientDisplay, 'Destinataire') === 0) {
                                    $recipientDisplay = trim($row['recipient_external_name'] ?? '');
                                }
                                if ($recipientDisplay === '') {
                                    $recipientDisplay = 'N/A';
                                }
                                $recipientPhone = trim($row['recipient_external_phone'] ?? '');
                            ?>
                            <tr>
                                <td>
                                    <div class="cell-strong">#<?php echo htmlspecialchars($row['id'], ENT_QUOTES, 'UTF-8'); ?></div>
                                    <div class="cell-muted">Demandé: <?php echo htmlspecialchars(date('Y-m-d H:i', strtotime($row['requested_at'] ?? 'now')), ENT_QUOTES, 'UTF-8'); ?></div>
                                </td>
                                <td><?php echo htmlspecialchars($row['province_name'] ?? 'N/A', ENT_QUOTES, 'UTF-8'); ?></td>
                                <td><?php echo htmlspecialchars($row['initiator_name'] ?? 'N/A', ENT_QUOTES, 'UTF-8'); ?></td>
                                <td>
                                    <div class="cell-strong"><?php echo htmlspecialchars($recipientDisplay, ENT_QUOTES, 'UTF-8'); ?></div>
                                    <?php if ($recipientPhone): ?><div class="cell-muted">Tél: <?php echo htmlspecialchars($recipientPhone, ENT_QUOTES, 'UTF-8'); ?></div><?php endif; ?>
                                </td>
                                <td><?php echo htmlspecialchars($row['cashier_name'] ?? 'N/A', ENT_QUOTES, 'UTF-8'); ?></td>
                                <td><?php echo htmlspecialchars($row['accountant_name'] ?? 'N/A', ENT_QUOTES, 'UTF-8'); ?></td>
                                <td class="cell-strong"><?php echo htmlspecialchars($row['receipt_number'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></td>
                                <td><?php echo htmlspecialchars(str_replace('_', ' ', $row['payment_method'] ?? '-'), ENT_QUOTES, 'UTF-8'); ?></td>
                                <td class="cell-strong"><?php echo number_format((float)($row['paid_amount'] ?? 0), 0, '.', ','); ?> BIF</td>
                                <td>
                                    <div class="cell-strong"><?php echo htmlspecialchars(date('Y-m-d H:i', strtotime($row['paid_at'] ?? 'now')), ENT_QUOTES, 'UTF-8'); ?></div>
                                    <?php if (!empty($row['comments'])): ?><div class="cell-muted">Notes: <?php echo htmlspecialchars($row['comments'], ENT_QUOTES, 'UTF-8'); ?></div><?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php include __DIR__ . '/../../includes/footer.php'; ?>
