<?php
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/functions.php';
require_login();

// Restrict to Stock Manager Assistant role
if ($_SESSION['role_name'] !== 'Stock Manager Assistant') {
    error_log("Unauthorized access to serve_orders.php by user {$_SESSION['full_name']} ({$_SESSION['role_name']})");
    header("Location: ./dashboards/operation_dashboard.php");
    exit;
}

// Fetch province_id
$conn = get_db_connection();
if (!$conn) {
    error_log("Database connection failed in serve_orders.php");
    echo "<p style='color: #FF0000; text-align: center; padding: 20px;'>Database connection failed. Contact administrator.</p>";
    include __DIR__ . '/../../includes/footer.php';
    exit;
}
if (!isset($_SESSION['province_id']) || $_SESSION['province_id'] === '') {
    $stmt = $conn->prepare("SELECT province_id FROM user WHERE id = ?");
    if (!$stmt) {
        error_log("Query preparation failed for province_id: " . $conn->error);
        echo "<p style='color: #FF0000; text-align: center; padding: 20px;'>Database error. Contact administrator.</p>";
        include __DIR__ . '/../../includes/footer.php';
        exit;
    }
    $stmt->bind_param("i", $_SESSION['user_id']);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();
    $_SESSION['province_id'] = $user['province_id'] ?? null;
    $stmt->close();
}
$province_id = $_SESSION['province_id'] ?? null;

if ($province_id === null || $province_id === '') {
    error_log("No province_id for user {$_SESSION['full_name']} (ID: {$_SESSION['user_id']})");
    echo "<p style='color: #FF0000; text-align: center; padding: 20px;'>Error: No province assigned. Contact administrator.</p>";
    include __DIR__ . '/../../includes/footer.php';
    exit;
}
$province_id = (int)$province_id;

// Handle serve status update
$errors = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_serve_status'])) {
    $order_id = (int)($_POST['order_id'] ?? 0);
    $stmt = $conn->prepare("UPDATE `order` SET serve_status = 'Served', updated_at = NOW() WHERE id = ? AND province_id = ? AND serve_status = 'Pending'");
    $stmt->bind_param("ii", $order_id, $province_id);
    if (!$stmt->execute()) {
        error_log("Serve status update failed: " . $stmt->error);
        $errors[] = "Failed to update serve status. Please try again.";
    }
    $stmt->close();
}

// Fetch pending orders
$stmt = $conn->prepare("SELECT o.id, o.customer_name, o.phone_number, p.name as product_name, o.quantity, o.sale_type, o.invoice_number, o.created_at 
                        FROM `order` o 
                        JOIN product p ON o.product_id = p.id 
                        WHERE o.province_id = ? AND o.serve_status = 'Pending' 
                        UNION 
                        SELECT o.id, o.customer_name, o.phone_number, p.name as product_name, o.quantity, o.sale_type, o.invoice_number, o.created_at 
                        FROM `order` o 
                        JOIN wholesale_products p ON o.product_id = p.id 
                        WHERE o.province_id = ? AND o.serve_status = 'Pending'");
$stmt->bind_param("ii", $province_id, $province_id);
$stmt->execute();
$pending_orders = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();

$conn->close();

include __DIR__ . '/../../includes/header.php';
?>
<div class="dashboard-container" style="padding: 20px; background: linear-gradient(135deg, #4B2F1F 0%, #F4A261 100%); min-height: 70vh;">
    <div class="dashboard-content" style="background-color: #F4F0E4; padding: 20px; border-radius: 10px; box-shadow: 0 4px 8px rgba(0,0,0,0.2); max-width: 800px; margin: auto;">
        <h2 style="color: #4B2F1F; margin-bottom: 10px;">Serve Pending Orders</h2>
        <p style="color: #000000; font-size: 16px;">Update serve status for orders in Masunzu Bar Hotel.</p>
        <?php if (!empty($errors)): ?>
            <div style="background-color: #FFFFFF; color: #FF0000; padding: 10px; border-radius: 5px; border: 1px solid #FF0000; margin-bottom: 10px;">
                <?php foreach ($errors as $error): ?>
                    <p><?php echo htmlspecialchars($error); ?></p>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
        <table style="width: 100%; border-collapse: collapse; background-color: #FFFFFF; border-radius: 8px; overflow: hidden; margin-bottom: 20px;">
            <thead>
                <tr style="background-color: #4B2F1F; color: #F4F0E4;">
                    <th style="padding: 12px; text-align: left;">Invoice</th>
                    <th style="padding: 12px; text-align: left;">Customer</th>
                    <th style="padding: 12px; text-align: left;">Phone</th>
                    <th style="padding: 12px; text-align: left;">Product</th>
                    <th style="padding: 12px; text-align: left;">Quantity</th>
                    <th style="padding: 12px; text-align: left;">Sale Type</th>
                    <th style="padding: 12px; text-align: left;">Date</th>
                    <th style="padding: 12px; text-align: left;">Action</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($pending_orders as $order): ?>
                    <tr style="border-bottom: 1px solid #F4F0E4;">
                        <td style="padding: 12px; text-align: left;"><?php echo htmlspecialchars($order['invoice_number']); ?></td>
                        <td style="padding: 12px; text-align: left;"><?php echo htmlspecialchars($order['customer_name']); ?></td>
                        <td style="padding: 12px; text-align: left;"><?php echo htmlspecialchars($order['phone_number']); ?></td>
                        <td style="padding: 12px; text-align: left;"><?php echo htmlspecialchars($order['product_name']); ?></td>
                        <td style="padding: 12px; text-align: left;"><?php echo htmlspecialchars($order['quantity']); ?></td>
                        <td style="padding: 12px; text-align: left;"><?php echo htmlspecialchars(ucfirst($order['sale_type'])); ?></td>
                        <td style="padding: 12px; text-align: left;"><?php echo date('Y-m-d H:i', strtotime($order['created_at'])); ?></td>
                        <td style="padding: 12px; text-align: left;">
                            <form method="POST" style="display: inline;">
                                <input type="hidden" name="order_id" value="<?php echo $order['id']; ?>">
                                <button type="submit" name="update_serve_status" style="padding: 8px; background-color: #F4A261; color: #000000; border: none; border-radius: 8px; font-size: 14px; cursor: pointer;">Mark as Served</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <div style="margin-top: 20px; text-align: center;">
            <a href="./dashboards/stock_manager_assistant_dashboard.php" style="background-color: #F4A261; color: #000000; padding: 10px 20px; border-radius: 8px; text-decoration: none; font-weight: bold;">Back to Dashboard</a>
        </div>
    </div>
</div>
<?php include __DIR__ . '/../../includes/footer.php'; ?>
