<?php
require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/auth.php';
require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/functions.php';
require_login();

$conn = get_db_connection();
$stmt = $conn->prepare("SELECT username, full_name, email, position FROM user WHERE id = ?");
$stmt->bind_param("i", $_SESSION['user_id']);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->num_rows === 1 ? $result->fetch_assoc() : null;
$stmt->close();
$conn->close();

if (!$user) {
    header("Location: /masunzu_bar_hotel/dashboards/admin_dashboard.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $full_name = trim($_POST['full_name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $position = trim($_POST['position'] ?? '');

    if ($full_name && $email) {
        $conn = get_db_connection();
        $stmt = $conn->prepare("SELECT id FROM user WHERE email = ? AND id != ?");
        $stmt->bind_param("si", $email, $_SESSION['user_id']);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result->num_rows > 0) {
            $error = "Email already exists.";
        } else {
            $stmt = $conn->prepare("UPDATE user SET full_name = ?, email = ?, position = ? WHERE id = ?");
            $stmt->bind_param("sssi", $full_name, $email, $position, $_SESSION['user_id']);
            $stmt->execute();
            $stmt->close();
            $conn->close();
            $_SESSION['full_name'] = $full_name; // Update session
            log_action($_SESSION['user_id'], 'update_profile', "Updated profile for user {$_SESSION['full_name']}");
            header("Location: /masunzu_bar_hotel/dashboards/admin_dashboard.php");
            exit;
        }
        $stmt->close();
        $conn->close();
    } else {
        $error = "Full name and email are required.";
    }
}
include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/header.php';
?>
<div class="form-container" style="padding: 20px; background-color: #F4F0E4; min-height: 70vh;">
    <h1 style="color: #4B2F1F; font-size: 28px; font-weight: bold; margin-bottom: 20px;">Profile Management</h1>
    <div class="form-content" style="background-color: #FFFFFF; padding: 20px; border-radius: 10px; box-shadow: 0 4px 8px rgba(0,0,0,0.1); max-width: 500px; margin: 0 auto;">
        <?php if (isset($error)): ?>
            <p style="color: red; font-size: 0.9em; margin-bottom: 10px;"><?php echo htmlspecialchars($error); ?></p>
        <?php endif; ?>
        <form method="POST">
            <div style="margin-bottom: 15px;">
                <label for="username" style="display: block; color: #4B2F1F; font-weight: bold; margin-bottom: 5px;">Nom d'utilisateur</label>
                <input type="text" id="username" name="username" value="<?php echo htmlspecialchars($user['username'] ?? ''); ?>" disabled style="width: 100%; padding: 12px; border: 2px solid #4B2F1F; border-radius: 8px; font-size: 16px; background-color: #F4F0E4; box-sizing: border-box;">
            </div>
            <div style="margin-bottom: 15px;">
                <label for="full_name" style="display: block; color: #4B2F1F; font-weight: bold; margin-bottom: 5px;">Nom complet <span style="color: red;">*</span></label>
                <input type="text" id="full_name" name="full_name" value="<?php echo htmlspecialchars($user['full_name'] ?? ''); ?>" required style="width: 100%; padding: 12px; border: 2px solid #4B2F1F; border-radius: 8px; font-size: 16px; box-sizing: border-box;">
            </div>
            <div style="margin-bottom: 15px;">
                <label for="email" style="display: block; color: #4B2F1F; font-weight: bold; margin-bottom: 5px;">Email <span style="color: red;">*</span></label>
                <input type="email" id="email" name="email" value="<?php echo htmlspecialchars($user['email'] ?? ''); ?>" required style="width: 100%; padding: 12px; border: 2px solid #4B2F1F; border-radius: 8px; font-size: 16px; box-sizing: border-box;">
            </div>
            <div style="margin-bottom: 20px;">
                <label for="position" style="display: block; color: #4B2F1F; font-weight: bold; margin-bottom: 5px;">Poste</label>
                <input type="text" id="position" name="position" value="<?php echo htmlspecialchars($user['position'] ?? ''); ?>" style="width: 100%; padding: 12px; border: 2px solid #4B2F1F; border-radius: 8px; font-size: 16px; box-sizing: border-box;">
            </div>
            <button type="submit" style="background-color: #F4A261; color: #000000; padding: 12px; border: none; border-radius: 8px; cursor: pointer; width: 100%; font-size: 16px; font-weight: bold;"><?php echo htmlspecialchars($lang['submit']); ?></button>
        </form>
    </div>
</div>
<?php include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/footer.php'; ?>